(**********************************************************************)
(*                                                                    *)
(*        tp-uhr, (c) 199?-1997 by Timo Baumann                       *)
(*        if you like this code, please contact me:                   *)
(*        timo@altavista.net                                          *)
(*                              based on examples by W. & V. Kassera  *)
(**********************************************************************)

program   TP_UHR;                            {TP-UHR.PAS}
{$M 1024,0,0}
uses      dos;
var       altvec       : pointer;

procedure tageszeit;  interrupt;
const     sichtbar:boolean=true;
          n:word=3980;
var       stunde,minuten,sekunden:word;
          rest:longint;
          zaehler:longint absolute $0040:$006C;
procedure uhrposi;
var       pw:byte;
procedure uhrweg;
const     i:byte=0;
begin
  repeat
    mem[$B800:i+n]:=0;
    inc(i,2)
  until i=20
end;
begin
  pw:=mem[0:$417] and $0f;
  if pw<>0 then begin
    uhrweg;
    case pw of
      $0d: sichtbar:=true;
      $0e: sichtbar:=false;
      $09: if n<3840 then inc(n,160);
      $0a: if n>=160 then dec(n,160);
      $05: if n<3980 then inc(n,2);
      $06: if n>0 then dec(n,2);
      $0b: begin
             memw[0:112]:=ofs(altvec^);
             memw[0:114]:=seg(altvec^);
             sichtbar:=false;
             mem[0:$4ff]:=0
           end
    end
  end
end;

procedure zeiguhr;
begin
  if sichtbar then begin
    stunde:=zaehler div 65543;
    rest:=zaehler mod 65543;
    minuten:=rest div 1092;
    rest:=rest mod 1092;
    sekunden:=trunc(rest/18.21);
    mem[$B800:n]:=179;
    mem[$B800:2+n]:=0;
    mem[$B800:4+n]:=(stunde div 10)+48;
    mem[$B800:6+n]:=(stunde mod 10)+48;
    mem[$B800:8+n]:=58;
    mem[$B800:10+n]:=(minuten div 10)+48;
    mem[$B800:12+n]:=(minuten mod 10)+48;
    mem[$B800:14+n]:=58;
    mem[$B800:16+n]:=(sekunden div 10)+48;
    mem[$B800:18+n]:=(sekunden mod 10)+48
  end
end;

begin
  uhrposi;
  zeiguhr
end;

begin
  writeln('TP-UHR (c) 1995, 1996 by Timo Baumann  all rights reserved');
  if mem[0:$4ff]=1 then begin   { 0:$4ff ist in der Regel unbentzt }
    writeln('TP-UHR oder ResiUhr ist bereits speicherresident!'); exit
  end;
  getintvec(28,altvec);
  setintvec(28,@tageszeit);
  mem[0:$4ff]:=1;
  keep(dosexitcode)
end.
